/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于常规参数
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 *************************************************************************************************/

/*
    依赖文件
    mc_data_template.js
    mc_sdk_reg_mgr.js
    mc_sdk_param.js
    mc_sdk_module.js
    mc_sdk_recvcard.js
    jquery-3.4.1.min.js
*/

/* global mc_sdk_get_param */
/* global mc_sdk_get_dicpchip_info_msg */
/* global mc_sdk_get_dispchip_access */
/* global mc_sdk_get_dispchip_normal */
/* global mc_sdk_set_param */
/* global mc_sdk_param */
/* global mc_crypto_set_box_md5_to_key */
/* global mc_ui_item_grp */
/* global $ */

// 控件类型
var G_ARR_UI_TYPE = new mc_ui_item_grp().get_ui_type();

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    常规参数更新流程(box_main)
 * 参数:
 *    @param {Promise<string>} box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 储存箱体数组
 *    @param {Promise<Array>} ary_mod_data 储存模组数组
 *    @param {Promise<object>} obj_ui_json_pamt 数据参数ui_json对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(实参:界面识别常规参数字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_get_pamtlist_by_sdk(box_name, ary_box_data, ary_mod_data, obj_ui_json_pamt, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("undefined" === typeof box_name) {
        fun_callback("", 1);
        return;
    }
    if (!(Array.isArray(ary_box_data)) || 0 >= ary_box_data.length) {
        fun_callback("", 1);
        return;
    }
    if (!(Array.isArray(ary_mod_data)) || 0 >= ary_mod_data.length) {
        fun_callback("", 1);
        return;
    }

    var ui_box_idx = mc_normal_get_idx_by_name(ary_box_data, box_name);
    var obj_box_data = ary_box_data[ui_box_idx];
    var obj_box_msg = obj_box_data.data.mc_util_get_ui_box_msg();
    var str_ctrlchip_name = obj_box_msg.ctrlchip_name;
    var str_mod_name = obj_box_data.data.mc_util_get_box_first_mod_name();
    var ui_mod_idx = mc_normal_get_idx_by_name(ary_mod_data, str_mod_name);
    var obj_sdk_module = ary_mod_data[ui_mod_idx].data;
    var str_dispchip_name = obj_sdk_module.mc_util_mod_get_disp_chip();
    var obj_normol_json = new mc_sdk_param();
    var obj_disp_nomal = new mc_sdk_param();
    // 储存使用页面值得属性值(换行,最短oe,最小换行,放电,图像帧刷新率)
    var obj_ui_val = new mc_sdk_param();
    var b_is_set_param = false;
    var str_dispchip_access = "";
    var str_tpl_json = "";

    // 获取常规参数
    mc_sdk_get_param(function (get_param_res) {
        if (!mc_normal_replace_val(obj_normol_json, get_param_res)) {
            parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
            fun_callback("", 2);
            return;
        }
        //获取显示芯片注册信息
        mc_sdk_get_dicpchip_info_msg(str_ctrlchip_name, str_dispchip_name, function (info_res) {
            var obj_info_json = new mc_sdk_param();

            obj_info_json.set_param_clear();
            obj_info_json.set_json(info_res);
            parent.G_OBJ_INFO_DATA.set_info_json(info_res);
            var str_pmw_val = obj_info_json.get_attr_val(str_dispchip_name, "PWM_IC");
            // 是否存在isolate参数
            var str_iso = obj_info_json.get_attr_val(str_dispchip_name, "ISOLATE");

            if (str_iso && 0 !== Number(str_iso)) {
                fun_callback("isolate");
                return;
            }

            //获取显示芯片常规参数
            mc_sdk_get_dispchip_normal([[str_ctrlchip_name, str_dispchip_name]], function (dispchip_access_res) {
                if ("string" === typeof dispchip_access_res && 0 < dispchip_access_res.length) {
                    obj_disp_nomal = new mc_sdk_param();

                    obj_disp_nomal.set_json(dispchip_access_res);
                    str_dispchip_access = obj_disp_nomal.get_attr_val(str_ctrlchip_name, "ITEMS");
                    var b_result = mc_normal_replace_val(obj_normol_json, str_dispchip_access);

                    if ("[OBJECT NUMBER]" === Object.prototype.toString.call(b_result).toLocaleUpperCase()) {
                        fun_callback("", 4);
                        return;
                    }

                    if (!b_result) {
                        str_dispchip_access = false;
                        //获取配置信息表
                        mc_normal_get_param_tpl_json(str_ctrlchip_name, str_pmw_val, function (str_tpl_json_res, str_costom_json) {
                            str_customer_json = str_costom_json;
                            if ("string" === typeof str_tpl_json_res && 0 < str_tpl_json_res.length) {
                                str_tpl_json = mc_normal_trans_to_item_json(str_tpl_json_res);
                                if (!mc_normal_replace_val(obj_normol_json, str_tpl_json)) {
                                    parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                                    fun_callback("", 2);
                                    return;
                                }
                                mc_handle_normal();
                                return;
                            }
                            // parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                            fun_callback("", 2);
                            return;
                        });
                    } else {
                        mc_handle_normal();
                        return;
                    }
                }

                function mc_handle_normal() {
                    var obj_ui_param = new mc_sdk_param();

                    obj_ui_param.set_param_clear();
                    obj_ui_param.set_json(JSON.stringify(obj_ui_json_pamt));
                    if (0 < obj_ui_param.get_param_cnt()) {
                        var str_trans_ui_json = mc_normal_trans_to_item_json(obj_ui_param.get_json());

                        if (!mc_normal_replace_val(obj_normol_json, str_trans_ui_json)) {
                            parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                            fun_callback("", 2);
                            return;
                        }
                    }
                    mc_normal_get_items_val(obj_ui_val, obj_normol_json);

                    var obj_box_param = obj_box_data.data.mc_util_get_param();

                    if (!mc_contrast_param(obj_box_param, obj_normol_json)) {
                        b_is_set_param = true;
                        obj_box_data.data.mc_util_set_param(obj_normol_json);
                    }

                    var str_ui_json = obj_normol_json.get_json();

                    //存入常规参数
                    mc_sdk_set_param(str_ui_json, function () {
                        // 获取直接访问显示芯片参数
                        mc_sdk_get_dispchip_access(str_dispchip_name, "", function (dispchip_access_new) {
                            if (!dispchip_access_new || 0 >= dispchip_access_new.length) {
                                parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                                fun_callback("", 2);
                                return;
                            }
                            obj_disp_nomal = new mc_sdk_param();
                            obj_disp_nomal.set_json(dispchip_access_new);
                            dispchip_access_new = obj_disp_nomal.get_param_value(str_dispchip_name);
                            if (!dispchip_access_new || 0 >= dispchip_access_new.length) {
                                parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                                fun_callback("", 2);
                                return;
                            }
                            //删除配置信息表中页面不识别类型
                            // 优先使用常规请求 后用配置表
                            if (str_dispchip_access) {
                                str_tpl_json = mc_normal_trans_tpl_json(str_dispchip_access);
                            } else {
                                str_tpl_json = mc_normal_trans_tpl_json(str_tpl_json);
                            }
                            var obj_ui_json = mc_normal_trans_to_ui_json(dispchip_access_new, obj_ui_val, str_tpl_json);

                            obj_disp_nomal.set_json(dispchip_access_new);

                            if (b_is_set_param) {
                                obj_box_data.data.mc_util_set_resul(obj_disp_nomal);
                            }

                            var str_box_md5 = mc_crypto_set_box_md5_to_key(obj_box_data);

                            for (var idx_box_list = 0; idx_box_list < ary_box_data.length; idx_box_list++) {
                                var obj_box_data_loc = ary_box_data[idx_box_list];
                                var str_box_md5_loc = mc_crypto_set_box_md5_to_key(obj_box_data_loc);

                                if (idx_box_list !== ui_box_idx && str_box_md5_loc === str_box_md5) {
                                    fun_callback(JSON.parse(obj_ui_json.get_json()), 3, idx_box_list);
                                    return;
                                }
                            }

                            fun_callback(JSON.parse(obj_ui_json.get_json()), 0);

                            return;
                        });
                    });
                }
            });
        });
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    常规参数更新流程(box_normal)
 * 参数:
 *    @param {Promise<String>} str_ctrlchip_name 主控芯片名称
 *    @param {Promise<String>} str_dispchip_name 显示芯片名称
 *    @param {Promise<object>} obj_ui_json_pamt 数据参数ui_json对象,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(实参:界面识别常规参数字串)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_get_normal_by_sdk_normal(str_ctrlchip_name, str_dispchip_name, obj_ui_json_pamt, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_normol_json = new mc_sdk_param();
    var obj_disp_nomal = new mc_sdk_param();
    // 储存使用页面值得属性值(换行,最短oe,最小换行,放电,图像帧刷新率)
    var obj_ui_val = new mc_sdk_param();

    var dispchip_access = "";
    var str_tpl_json = "";

    // 获取常规参数
    mc_sdk_get_param(function (get_param_res) {
        if (!mc_normal_replace_val(obj_normol_json, get_param_res)) {
            parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
            fun_callback(false);
            return;
        }
        //获取显示芯片注册信息
        mc_sdk_get_dicpchip_info_msg(str_ctrlchip_name, str_dispchip_name, function (info_res) {
            var obj_info_json = new mc_sdk_param();

            obj_info_json.set_param_clear();
            obj_info_json.set_json(info_res);
            var str_pmw_val = obj_info_json.get_attr_val(str_dispchip_name, "PWM_IC");


            //获取显示芯片常规参数
            mc_sdk_get_dispchip_normal([[str_ctrlchip_name, str_dispchip_name]], function (dispchip_access_res) {
                if ("string" === typeof dispchip_access_res && 0 < dispchip_access_res.length) {
                    obj_disp_nomal = new mc_sdk_param();
                    obj_disp_nomal.set_json(dispchip_access_res);
                    dispchip_access = obj_disp_nomal.get_attr_val(str_ctrlchip_name, "ITEMS");

                    var b_result = mc_normal_replace_val(obj_normol_json, dispchip_access);

                    if ("[OBJECT NUMBER]" === Object.prototype.toString.call(b_result).toLocaleUpperCase()) {
                        fun_callback("", 4);
                        return;
                    }

                    if (!b_result) {
                        dispchip_access = false;
                        //获取配置信息表
                        mc_normal_get_param_tpl_json(str_ctrlchip_name, str_pmw_val, function (str_tpl_json_res, str_costom_json) {
                            str_customer_json = str_costom_json;

                            if ("string" === typeof str_tpl_json_res && 0 < str_tpl_json_res.length) {
                                str_tpl_json = mc_normal_trans_to_item_json(str_tpl_json_res);
                                if (!mc_normal_replace_val(obj_normol_json, str_tpl_json)) {
                                    parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                                    fun_callback(false);
                                    return;
                                }
                                mc_handle_normal_page();
                            }
                            fun_callback("", 2);
                            return;
                        });
                    } else {
                        mc_handle_normal_page();
                        return;
                    }
                }

                function mc_handle_normal_page() {
                    var obj_ui_param = new mc_sdk_param();

                    obj_ui_param.set_param_clear();
                    obj_ui_param.set_json(JSON.stringify(obj_ui_json_pamt));
                    if (0 < obj_ui_param.get_param_cnt()) {
                        var str_trans_ui_json = mc_normal_trans_to_item_json(obj_ui_param.get_json());

                        if (!mc_normal_replace_val(obj_normol_json, str_trans_ui_json)) {
                            parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                            fun_callback(false);
                            return;
                        }
                    }
                    mc_normal_get_items_val(obj_ui_val, obj_normol_json);
                    var str_ui_json = obj_normol_json.get_json();

                    //存入常规参数
                    mc_sdk_set_param(str_ui_json, function () {
                        // 获取直接访问显示芯片参数
                        mc_sdk_get_dispchip_access(str_dispchip_name, "", function (dispchip_access_new) {
                            if (!dispchip_access_new || 0 >= dispchip_access_new.length) {
                                parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                                fun_callback(false);
                                return;
                            }
                            obj_disp_nomal = new mc_sdk_param();
                            obj_disp_nomal.set_json(dispchip_access_new);
                            dispchip_access_new = obj_disp_nomal.get_param_value(str_dispchip_name);
                            if (!dispchip_access_new || 0 >= dispchip_access_new.length) {
                                parent.mc_alert_popout("MC_LANG_MC_REQUEST_ERR");
                                fun_callback(false);
                                return;
                            }
                            //删除配置信息表中页面不识别类型
                            if (dispchip_access) {
                                str_tpl_json = mc_normal_trans_tpl_json(dispchip_access);
                            } else {
                                str_tpl_json = mc_normal_trans_tpl_json(str_tpl_json);
                            }

                            var obj_ui_json = mc_normal_trans_to_ui_json(dispchip_access_new, obj_ui_val, str_tpl_json);

                            fun_callback(obj_ui_json.get_json());

                            return;
                        });
                    });
                }
            });
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取配置表信息列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip_name 主控芯片名称
 *    @param {Promise<string>} str_pmw_val pmw_ic的val
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(tpl_json字串)
 * 返回：
 *    NA
 * 备注 :
 *      返回参数2: 客户文件 用于显示客户想要的值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_get_param_tpl_json(str_ctrlchip_name, str_pmw_val, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fun_callback("");
        return;
    }
    if ("string" !== typeof str_pmw_val || 0 >= str_pmw_val.length) {
        fun_callback("");
        return;
    }
    var ui_pmw_val = Number(str_pmw_val);
    var str_ctr_url = "";
    var str_url = "";

    switch (ui_pmw_val) {
        case 1:
            str_ctr_url = "/pages/box_main/" + str_ctrlchip_name.toUpperCase() + "/common_param_pwm.json";
            str_url = "/pages/box_main/common_param_pwm.json";
            break;
        default:
            str_ctr_url = "/pages/box_main/" + str_ctrlchip_name.toUpperCase() + "/common_param_general.json";
            str_url = "/pages/box_main/common_param_general.json";
            break;
    }
    var str_costom_url = "/pages/box_main/custom_param.json";

    var str_ctrl_file = "";
    // var str_no_ctrl_file = "";
    var str_cus_file = "";

    $.ajax(str_ctr_url, {
        type: "get",
        async: false,
        success: function (str_val) {
            str_ctrl_file = str_val;
            // $.get(str_ctr_url, function (str_ctr_tpl_json, status) {
            // str_ctrl_file = str_ctr_tpl_json;
            $.ajax({
                url: str_costom_url,
                type: "get",
                async: false,
                success: function (str_custom_json) {
                    fun_callback(str_ctrl_file, str_custom_json);
                    return;
                },
                error: function (err_cus_1) {
                    if (200 === err_cus_1.status) {
                        str_cus_file = err_cus_1.responseText;
                    }
                    fun_callback(str_ctrl_file, "");
                    return;
                }
            });
            // }, "text");
        },
        error: function (err_ctrl) {
            //避免获取主控的文件时获取成功不进入success
            if (200 === err_ctrl.status) {
                str_ctrl_file = err_ctrl.responseText;

                $.ajax({
                    url: str_costom_url,
                    type: "get",
                    async: false,
                    success: function (str_custom_json) {
                        fun_callback(str_ctrl_file, str_custom_json);
                        return;
                    },
                    error: function (err_cus_2) {
                        if (200 === err_cus_2.status) {
                            str_cus_file = err_cus_2.responseText;
                        }

                        fun_callback(str_ctrl_file, str_cus_file);
                        return;
                    }
                });


                return;
            }

            $.get(str_url, function (str_tpl_json) {
                $.ajax({
                    url: str_costom_url,
                    type: "get",
                    async: false,
                    success: function (str_custom_json) {
                        fun_callback(str_tpl_json, str_custom_json);
                        return;
                    },
                    error: function (err_custom_3) {
                        if (200 === err_custom_3.status) {
                            str_cus_file = err_custom_3.responseText;
                        }

                        fun_callback(str_tpl_json, str_cus_file);
                        return;
                    }
                });
            }, "text");
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    储存使用页面值的属性值
 * 参数:
 *    @param {Promise<object>} obj_items_json mc_sdk_param实例对象(储存对象)
 *    @param {Promise<string>} obj_param_json mc_sdk_param实例对象(下发数据)
 * 返回：
 *    @returns {Promise<boolean>} 储存结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_get_items_val(obj_items_json, obj_param_json) {
    var ary_use_ui_param_list = [
        //最小放电时间
        "CLOSE_TIME",
        // OE最小时间
        "MIN_OE_TIME",
        // 换行时间偏移量
        "SCAN_CHANGE_OFFSET_TIME",
        // 最小换行时间
        "SCAN_CHANGE_TIME",
        // 帧刷新率
        "FRME_REFRESH_FREQ",
        // 数据时钟的基准时钟频率
        "DATA_LEVEL_FREQ",
        // 灰度时钟频率
        "GRAY_LEVEL_FREQ",
        // 帧头等待时间
        "FRME_HEAD_WAIT",
        // 帧尾等待时间
        "FRME_TAIL_WAIT",
        // 输入位宽
        "PIX_INPUT_BIT_SIZE"
    ];

    for (var idx_list = 0; idx_list < ary_use_ui_param_list.length; idx_list++) {
        var str_param_name = ary_use_ui_param_list[idx_list];
        var str_param_val = obj_param_json.get_param_value(str_param_name);

        if ("NAN" !== (Number(str_param_val) + "").toUpperCase()) {
            obj_items_json.set_param_value(str_param_name, str_param_val);
        }
    }
    return true;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    删除配置信息表中页面不识别参数
 * 参数:
 *    @param {Promise<string>} str_tpl_json 配置信息字串
 * 返回：
 *    @returns {Promise<string>} 页面识别配置信息字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_trans_tpl_json(str_tpl_json) {
    if ("string" !== typeof str_tpl_json || 0 >= str_tpl_json.length) {
        return false;
    }
    var obj_tpl_json = new mc_sdk_param();

    if (!obj_tpl_json.set_json(str_tpl_json)) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();
    var ui_param_cnt = obj_tpl_json.get_param_cnt();

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_param_name = obj_tpl_json.get_param_name(idx_param);
        var str_ui_type = obj_tpl_json.get_attr_val(str_param_name, "UI_TYPE");

        if ("function" !== typeof G_ARR_UI_TYPE[str_ui_type]) {
            continue;
        }

        var str_param_val = obj_tpl_json.get_param_value(str_param_name);

        obj_sdk_param.set_param_value(str_param_name, str_param_val);
        var ui_att_cnt = obj_tpl_json.get_attr_cnt(str_param_name);

        for (var idx_attr = 0; idx_attr < ui_att_cnt; idx_attr++) {
            var str_attr_name = obj_tpl_json.get_attr_name(str_param_name, idx_attr);
            var str_attr_val = obj_tpl_json.get_attr_val(str_param_name, str_attr_name);

            obj_sdk_param.set_attr_val(str_param_name, str_attr_name, str_attr_val);
        }
    }
    return obj_sdk_param.get_json();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换为发送字串
 * 参数:
 *    @param {Promise<string>} str_ui_json 页面数据字串
 * 返回：
 *    @returns {Promise<string>} 转换后的字串
 * 备注:
 *    发送至sdk的数据中目前仅一个属性需要处理,但不排除往后有增加的可能,故独立一个函数管理
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_trans_to_item_json(str_ui_json) {
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    if (!obj_sdk_param.set_json(str_ui_json)) {
        return false;
    }
    var str_param_name = "DATA_LEVEL_RATIO";
    var str_param_val = obj_sdk_param.get_param_value(str_param_name);

    if (!str_param_val || -1 !== str_param_val.indexOf(".")) {
        return str_ui_json;
    }
    str_param_val = (Number(str_param_val) / 100) + "";
    obj_sdk_param.set_param_value(str_param_name, str_param_val);
    return obj_sdk_param.get_json();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换为页面识别字串
 * 参数:
 *    @param {Promise<string>} str_item_json mc_sdk_param描述字串(sdk返回数据)
 *    @param {Promise<object>} obj_ui_val mc_sdk_param实例对象(使用页面值)
 *    @param {Promise<string>} str_tpl_json mc_sdk_param描述字串(配置信息表)
 * 返回：
 *    @returns {Promise<string>} 转换后的字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_trans_to_ui_json(str_item_json, obj_ui_val, str_tpl_json) {   /* eslint-disable-line */
    var obj_item_json = new mc_sdk_param();
    var obj_tpl_json = new mc_sdk_param();

    if (!obj_item_json.set_json(str_item_json) || !obj_tpl_json.set_json(str_tpl_json)) {
        return false;
    }
    var ui_tpl_cnt = obj_tpl_json.get_param_cnt();

    for (var idx_param = 0; idx_param < ui_tpl_cnt; idx_param++) {
        // 以配置信息表参数为标准
        var str_param_name = obj_tpl_json.get_param_name(idx_param);
        // 获取sdk内容,如果没有则使用自身的
        var str_param_val = obj_item_json.get_param_value(str_param_name);
        var str_items_val = obj_ui_val.get_param_value(str_param_name);

        if ("string" === typeof str_items_val && 0 < str_items_val.length) {
            str_param_val = str_items_val;
        }
        if ("string" === typeof str_param_val && 0 < str_param_val.length) {
            obj_tpl_json.set_param_value(str_param_name, str_param_val);
        }

        // 处理单位 设置 TAIL_ID_LIST
        var str_tail_value = obj_tpl_json.get_attr_val(str_param_name, "TAIL_ID_LIST");
        var str_attr_val = "";

        if ("string" === typeof str_tail_value && -1 !== str_tail_value.indexOf(",(<DISPCHIP_VALUE>)")) {
            str_attr_val = obj_item_json.get_param_value("BASE_TIME");
            str_param_val = obj_item_json.get_param_value(str_param_name);

            var str_calc_res = "null";

            if (!isNaN(Number(str_attr_val))) {
                str_calc_res = (Number(str_param_val) * Number(str_attr_val));
            }
            if ("DATA_LEVEL_FREQ" === str_param_name) {
                var ui_param_val = Number(obj_item_json.get_param_value("DATA_LEVEL_CNT"));
                var ui_base_time_val = Number(obj_item_json.get_param_value("BASE_TIME"));

                if (isNaN(ui_param_val) || 0 === ui_param_val || isNaN(ui_base_time_val) || 0 === ui_param_val) {
                    str_calc_res = "NA";
                } else {
                    str_calc_res = ((1000 / (ui_param_val * ui_base_time_val)).toFixed(2)) + "";
                }
            }
            if ("GRAY_LEVEL_FREQ" === str_param_name) {
                str_param_val = obj_item_json.get_param_value("GRAY_BIT_SIZE");

                str_calc_res = str_param_val;
            }
            str_attr_val = str_tail_value.split(",(<DISPCHIP_VALUE>)")[0] + ",(" + str_calc_res + ")";
            obj_tpl_json.set_attr_val(str_param_name, "TAIL_ID_LIST", str_attr_val);
        }

        // 返回内容有些参数需要处理
        mc_normal_dispose_param(obj_tpl_json, obj_item_json, str_param_name, str_param_val);

        // 设置 ARRAY
        var str_array_val = obj_tpl_json.get_attr_val(str_param_name, "ARRAY");

        if (!str_array_val) {
            continue;
        }
        var ary_array_val = mc_normal_splice_str(str_array_val, ",");

        str_param_val = obj_tpl_json.get_param_value(str_param_name);
        str_attr_val = "";
        for (var idx_attr = 0; idx_attr < ary_array_val.length; idx_attr++) {
            if (-1 !== ary_array_val[idx_attr].indexOf("=")) {
                break;
            }
            str_attr_val += ary_array_val[idx_attr] + "=" + ary_array_val[idx_attr] + ",";
        }
        if (0 !== str_attr_val.length) {
            str_attr_val = str_attr_val.substring(0, str_attr_val.length - 1);
            obj_tpl_json.set_attr_val(str_param_name, "ARRAY", str_attr_val);
        }
    }

    // 错误码和亮度有效率
    var ui_err_val = obj_item_json.get_param_value("ERROR_CODE");

    obj_tpl_json.set_param_value("ERROR_CODE", ui_err_val);
    var str_lumi_effict = obj_item_json.get_param_value("LUMI_EFFICT");

    if ("0" === ui_err_val) {
        var ui_lumi_effict = Number(str_lumi_effict);

        if (1 >= ui_lumi_effict) {
            ui_lumi_effict *= 100;
            ui_lumi_effict = Math.floor(ui_lumi_effict);
            str_lumi_effict = ui_lumi_effict + "%";
            obj_tpl_json.set_param_value("LUMI_EFFICT", str_lumi_effict);
        }
    }

    // 处理偏差位值
    mc_normal_level_offset_max_min(obj_tpl_json, obj_item_json);
    mc_normal_param_val_check(obj_tpl_json);

    return obj_tpl_json;
}

/* 处理参数 */
function mc_normal_dispose_param(obj_tpl_json, obj_item_json, str_param_name, str_parms_value) {
    var str_param_val = "";
    var str_attr_val = "";
    var idx_attr = 0;

    if ("SCAN_REFRESH_FREQ" === str_param_name) {
        str_param_val = obj_item_json.get_param_value("ROW_FREQ");
        obj_tpl_json.set_param_value(str_param_name, str_param_val);
        str_attr_val = obj_item_json.get_param_value("SCAN_REFRESH_LIST");

        str_attr_val = mc_normal_dispose_array_val(str_attr_val);
        if ("string" !== typeof str_attr_val || 0 >= str_attr_val.length) {
            str_attr_val = str_param_val + "=" + str_param_val;
        }
        obj_tpl_json.set_attr_val(str_param_name, "ARRAY", str_attr_val);
    } else if ("FREQ_UPS" === str_param_name) {
        str_attr_val = obj_item_json.get_param_value("ENABLED_FREQ_UPS_ARY");
        var ary_array_val = mc_normal_splice_str(str_attr_val, ",");

        if (0 >= ary_array_val.length) {
            obj_tpl_json.set_param_value(str_param_name, "1");
            ary_array_val = ["1"];
        }
        str_attr_val = "";
        for (idx_attr = 0; idx_attr < ary_array_val.length; idx_attr++) {
            str_attr_val += ary_array_val[idx_attr] + "=" + ary_array_val[idx_attr] + ",";
        }
        obj_tpl_json.set_attr_val(str_param_name, "ARRAY", str_attr_val.substring(0, str_attr_val.length - 1));
    } else if ("GRAY_LEVEL_RATIO" === str_param_name) {
        str_parms_value = Number(str_parms_value) * 100 + "";
        if ("NAN" === str_parms_value.toUpperCase()) {
            str_parms_value = "0";
        }
        obj_tpl_json.set_param_value(str_param_name, str_parms_value);
    } else if ("DATA_LEVEL_RATIO" === str_param_name) {
        str_parms_value = Number(str_parms_value) * 100 + "";
        if ("NAN" === str_parms_value.toUpperCase()) {
            str_parms_value = "0";
        }
        obj_tpl_json.set_param_value(str_param_name, str_parms_value);
    } else if ("DISP_MODE" === str_param_name) {
        str_attr_val = obj_item_json.get_param_value("ENABLED_DISP_MODE_ARY");
        var ary_arry_value = mc_normal_splice_str(str_attr_val, ",");

        if (0 >= ary_arry_value.length) {
            ary_arry_value = [str_parms_value];
        }
        str_attr_val = "";
        for (idx_attr = 0; idx_attr < ary_arry_value.length; idx_attr++) {
            switch (parseInt(ary_arry_value[idx_attr], 10)) {
                case 0:
                    str_attr_val += "0=" + "DISP_MODE_DEFAULT,";
                    break;
                case 1:
                    str_attr_val += "1=" + "DISP_MODE_FRESH_PRI,";
                    break;
                case 2:
                    str_attr_val += "2=" + "DISP_MODE_GRAY_PRI,";
                    break;
                case 3:
                    str_attr_val += "3=" + "DISP_MODE_BRIGHTNESS_PRI,";
                    break;
                case 4:
                    str_attr_val += "4=" + "DISP_MODE_HIGHFRESH_PRI,";
                    break;
                case 6:
                    str_attr_val += "6=" + "DISP_MODE_BALANCE,";
                    break;
                default:
                    break;
            }
        }
        obj_tpl_json.set_attr_val(str_param_name, "ARRAY", str_attr_val.substring(0, str_attr_val.length - 1));
    }
}

/* 设置相位偏移最大最小值 */
function mc_normal_level_offset_max_min(obj_tpl_json, obj_item_json) {
    var ui_level_freq = Number(obj_tpl_json.get_param_value("DATA_LEVEL_FREQ"));
    var ui_base_time = Number(obj_item_json.get_param_value("BASE_TIME"));
    var ui_level_offset = Number(obj_tpl_json.get_param_value("DATA_LEVEL_OFFSET"));

    if (
        isNaN(ui_level_freq) ||
        isNaN(ui_base_time) ||
        isNaN(ui_level_offset)
    ) {
        return;
    }
    // 相位偏移的最大及最小值
    var ui_offset_m = Number((1000 / ui_level_freq) / ui_base_time);

    if (0 !== ui_offset_m % 1) {
        ui_offset_m = parseInt(ui_offset_m, 10) + 1;
    }

    obj_tpl_json.set_attr_val("DATA_LEVEL_OFFSET", "MIN_VAL", (-ui_offset_m).toString());
    obj_tpl_json.set_attr_val("DATA_LEVEL_OFFSET", "MAX_VAL", (ui_offset_m).toString());
}

// 参数校验
function mc_normal_param_val_check(obj_sdk_param) {
    var ui_param_cnt = obj_sdk_param.get_param_cnt();

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_param_name = obj_sdk_param.get_param_name(idx_param);
        var str_ui_type = obj_sdk_param.get_attr_val(str_param_name, "UI_TYPE");
        var str_param_value = obj_sdk_param.get_param_value(str_param_name);

        if ("OPTION" !== str_ui_type || isNaN(Number(str_param_value))) {
            continue;
        }

        var str_array = obj_sdk_param.get_attr_val(str_param_name, "ARRAY");
        var ary_array = str_array.split(",");
        var idx_array = 0;

        for (idx_array = 0; idx_array < ary_array.length; idx_array++) {
            var str_atr_val = ary_array[idx_array];

            str_atr_val = str_atr_val.split("=")[0];
            if (Number(str_atr_val) === Number(str_param_value)) {
                break;
            }
        }

        if (idx_array === ary_array.length) {
            idx_array = 0;
        }

        obj_sdk_param.set_param_value(str_param_name, ary_array[idx_array].split("=")[0].trim());
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将字串内容存入对象
 * 参数:
 *    @param {Promise<object>} obj_replace_json 存值对象
 *    @param {Promise<string>} str_give_json 给值字串
 * 返回：
 *    @returns {Promise<boolean>} 储存结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_replace_val(obj_replace_json, str_give_json) {
    if ("string" !== typeof str_give_json || 0 >= str_give_json.length) {
        return false;
    }
    var obj_give_json = new mc_sdk_param();

    // 不是json/json为空 则找配置表
    if (!obj_give_json.set_json(str_give_json) || !str_give_json) {
        return false;
    }
    var ui_replace_cnt = obj_give_json.get_param_cnt();

    // 是json 没参数则直接返回不找配置表
    if (0 === ui_replace_cnt) {
        return 0;
    }
    for (var idx_param = 0; idx_param < ui_replace_cnt; idx_param++) {
        var str_param_name = obj_give_json.get_param_name(idx_param);
        var str_param_val = obj_give_json.get_param_value(str_param_name);

        obj_replace_json.set_param_value(str_param_name, str_param_val);
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理array属性值
 * 参数:
 *    @param {Promise<string>} str_array_val 参数json字串,传入的ui_json字串,参数可以为空
 * 返回：
 *    @returns {Promise<string>} 处理好的array属性值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_dispose_array_val(str_array_val) {
    if ("string" !== typeof str_array_val || 0 >= str_array_val.length) {
        return "";
    }
    var ary_array_val = mc_normal_splice_str(str_array_val, ",");
    var idx_array = 0;
    var str_array_val_dispose = "";
    var str_dispose_val = "";

    if (mc_normal_splice_str(ary_array_val[0], "=")[0] === ary_array_val[0]) {
        for (idx_array = 0; idx_array < ary_array_val.length; idx_array++) {
            str_dispose_val = ary_array_val[idx_array] + "=" + ary_array_val[idx_array] + ",";
            str_array_val_dispose += str_dispose_val;
        }
        return str_array_val_dispose.substring(0, str_array_val_dispose.length - 1);
    }
    return str_array_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    字符串截取
 * 参数:
 *    @param {Promise<string>} str_param 处理参数
 *    @param {Promise<string>} str_way 处理方式
 * 返回：
 *    @return {Promise<Array>} 截取后生成的数组;
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_splice_str(str_param, str_way) {
    if ("string" !== typeof str_param || 0 >= str_param.length) {
        return [];
    }
    if (-1 === str_param.indexOf(str_way)) {
        return [str_param];
    }
    return str_param.split(str_way);
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据名称获取箱体或模组对应下标
 * 参数:
 *    @param {Promise<Array>} ary_data 储存模组或箱体的数组
 *    @param {Promise<string>} str_name 查询名称
 * 返回：
 *    @return {Promise<Unit>} 对应名称所在下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_get_idx_by_name(ary_data, str_name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    if ("string" !== typeof str_name || 0 >= str_name.length) {
        return false;
    }
    var ui_idx = 0;

    for (var idx = 0; idx < ary_data.length; idx++) {
        if (!ary_data[idx].name) {
            return false;
        }
        if (ary_data[idx].name === str_name) {
            ui_idx = idx;
            break;
        }
    }
    return ui_idx;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据名称获取箱体或模组对应下标
 * 参数:
 *    @param {Promise<Array>} ary_data 储存模组或箱体的数组
 *    @param {Promise<string>} str_name 查询名称
 * 返回：
 *    @return {Promise<Unit>} 对应名称所在下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_normal_get_idx_by_name(ary_data, str_name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    if ("string" !== typeof str_name || 0 >= str_name.length) {
        return false;
    }
    var ui_idx = 0;

    for (var idx = 0; idx < ary_data.length; idx++) {
        if (!ary_data[idx].name) {
            return false;
        }
        if (ary_data[idx].name === str_name) {
            ui_idx = idx;
            break;
        }
    }
    return ui_idx;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据内存中的常规参数内容,获取页面ui_json字串
 * 参数:
 *    @param {Promise<string>} b_loading 是加载配置时
 *    @param {Promise<string>} str_box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 箱体数据数组
 *    @param {Promise<Array>} ary_mod_data 模组数据数组
 *    @param {Promise<Function>} fn_callback 回调函数(页面识别ui_json字串)
 * 返回：
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_param_trans_internal(b_loading, str_box_name, ary_box_data, ary_mod_data, fn_callback) {
    if (!b_loading) {
        fn_callback("");
        return;
    }
    var ui_box_idx = mc_normal_get_idx_by_name(ary_box_data, str_box_name);

    if ("number" !== typeof ui_box_idx) {
        fn_callback("");
        return;
    }
    var str_item_json = ary_box_data[ui_box_idx].param_item;
    var str_ui_json = ary_box_data[ui_box_idx].param_ui;
    var str_ctrlchip_name = ary_box_data[ui_box_idx].ctrlchip_name;
    var str_first_mod_name = ary_box_data[ui_box_idx].first_mod_name;
    var ui_mod_idx = mc_normal_get_idx_by_name(ary_mod_data, str_first_mod_name);

    if (!str_ui_json || 0 >= str_ui_json.length || "number" !== typeof ui_mod_idx) {
        fn_callback("");
        return;
    }
    var str_dispchip_name = ary_mod_data[ui_mod_idx].dispchip_name;

    //获取显示芯片注册信息
    mc_sdk_get_dicpchip_info_msg(str_ctrlchip_name, str_dispchip_name, function (info_res) {
        var obj_info_json = new mc_sdk_param();

        obj_info_json.set_param_clear();
        obj_info_json.set_json(info_res);
        var str_pmw_val = obj_info_json.get_attr_val(str_dispchip_name, "PWM_IC");

        //获取配置信息表
        mc_normal_get_param_tpl_json(str_ctrlchip_name, str_pmw_val, function (str_tpl_json) {
            // console.log(str_costom_json);
            var obj_normol_json = new mc_sdk_param();
            var obj_ui_val = new mc_sdk_param();

            obj_normol_json.set_json(str_item_json);
            mc_normal_get_items_val(obj_ui_val, obj_normol_json);
            mc_sdk_get_dispchip_access(str_dispchip_name, "", function (dispchip_access_new) {
                var obj_access_json = new mc_sdk_param();
                var obj_result_json = new mc_sdk_param();

                obj_access_json.set_json(dispchip_access_new);
                obj_access_json.set_json(obj_access_json.get_param_value(str_dispchip_name));
                obj_result_json.set_json(str_ui_json);
                obj_result_json.set_param_value("BASE_TIME", obj_access_json.get_param_value("BASE_TIME"));
                str_ui_json = obj_result_json.get_json();
                var obj_ui_json = mc_normal_trans_to_ui_json(str_ui_json, obj_ui_val, str_tpl_json);

                fn_callback(obj_ui_json.get_json());
            });
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    对比参数1中的内容是否与2的内容是否一定
 * 参数:
 *    @param {Promise<string>} obj_param_1 是加载配置时
 *    @param {Promise<string>} obj_param_2 箱体名称
 * 返回：
 *    @returns {Promise<Boolean>} 比较结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2021.1.8
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_contrast_param(obj_param_1, obj_param_2) {
    if (
        !obj_param_1.get_param_cnt ||
        !obj_param_2.get_param_cnt
    ) {
        return false;
    }

    var ui_param_cnt_1 = obj_param_1.get_param_cnt();
    var ui_param_cnt_2 = obj_param_2.get_param_cnt();

    if (
        0 >= ui_param_cnt_1 ||
        0 >= ui_param_cnt_2
    ) {
        return false;
    }

    for (var idx_param = 0; idx_param < ui_param_cnt_1; idx_param++) {
        var str_param_name = obj_param_1.get_param_name(idx_param);
        var str_param_1 = obj_param_1.get_param_value(str_param_name);
        var str_param_2 = obj_param_2.get_param_value(str_param_name);

        if (
            !str_param_2 ||
            str_param_2 !== str_param_1
        ) {
            return false;
        }
    }
    return true;
}

/********** EXPORT API *********************************************************************************/
/* exported mc_normal_update_pamtlist */
/* exported mc_normal_update_pamtlist_normal */
/* exported mc_param_trans_internal */

/* 更新常规参数区域数据 */
/**
 * @param {string} box_name 箱体名称
 * @param {Array} ary_box_data 箱体数据
 * @param {Array} ary_mod_data 模组数据
 * @param {string} obj_ui_json_pamt ui识别的json字串转成的json对象
 * @param {Function} fun_callback 获取参数回调函数
 * @returns {Function} 执行函数
 */
function mc_normal_update_pamtlist(box_name, ary_box_data, ary_mod_data, obj_ui_json_pamt, fun_callback) {
    return mc_normal_get_pamtlist_by_sdk(box_name, ary_box_data, ary_mod_data, obj_ui_json_pamt, fun_callback);
}
/* 更新常规参数区域数据 */
/**
 * @param {String} str_ctrlchip_name 主控芯片名称
 * @param {String} str_dispchip_name 显示芯片名称
 * @param {Object} obj_ui_json_pamt ui识别的json字串转成的json对象
 * @param {Function} fun_callback 获取参数回调函数
 * @returns {Function} 执行函数
 */
function mc_normal_update_pamtlist_normal(str_ctrlchip_name, str_dispchip_name, obj_ui_json_pamt, fun_callback) {
    return mc_normal_get_normal_by_sdk_normal(str_ctrlchip_name, str_dispchip_name, obj_ui_json_pamt, fun_callback);
}
